#include "probes.h"

static int test0val = 0;
static int test1val = 0;
static int test2val = 0;
static int test3val = 0;
static int test4val = 0;
static int test10val = 0;

JNIEXPORT void JNICALL Java_com_nvidia_devtech_jniperftest_JNIPerfTest_initTests(JNIEnv *env, jobject obj)
{
	test0val = 0;
	test1val = 0;
	test2val = 0;
	test3val = 0;
	test4val = 0;
	test10val = 0;
}

JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void *reserved) {
	JNIEnv* env = NULL;
	jint result = -1;

	if ((*vm)->GetEnv(vm, (void**) &env, JNI_VERSION_1_4) != JNI_OK) {
		LOGI("ERROR: GetEnv failed");
		goto tail;
	}

	if (initProbesSys() == -1) {
		LOGI("ERROR: initProbesSys failed");
		goto tail;
	}
	LOGI("JNI_OnLoad");

	result = JNI_VERSION_1_4;
tail:
	return result;
}

JNIEXPORT jint JNICALL Java_com_nvidia_devtech_jniperftest_JNIPerfTest_ntest10(JNIEnv *env, jobject obj, jstring jname, jboolean f_type, jstring jcname, jboolean reg)
{
	const char *nname = (*env)->GetStringUTFChars(env, jname, 0);
	const char *ncname = (*env)->GetStringUTFChars(env, jcname, 0);

	if(f_type == JNI_TRUE) {
		if(reg == JNI_TRUE) {
			if(isActiveProbe(nname) == 1)
				if(isRegCaller(ncname, nname) == 1)
					activeLog(nname);
		}
		else {
			if(isActiveProbe(nname) == 1)
				if(isUnRegCaller(nname) == 1)
					activeLog(nname);
		}
	}
	else {
		if(isActiveProbe(nname) == 1)
			activeLog(nname);
	}

	(*env)->ReleaseStringUTFChars(env, jname, nname);
	(*env)->ReleaseStringUTFChars(env, jcname, ncname);

	return test10val++;
}

JNIEXPORT void JNICALL Java_com_nvidia_devtech_jniperftest_JNIPerfTest_ntest8(JNIEnv *env, jobject obj)
{
	int i;
	int a = 0;
	
	for(i=0;i<10000;i++)
	{
		a++;
	}
}

JNIEXPORT jint JNICALL Java_com_nvidia_devtech_jniperftest_JNIPerfTest_ntest1(JNIEnv *env, jobject obj, jstring jname, jboolean f_type, jstring jcname, jboolean reg)
{
	const char *nname = (*env)->GetStringUTFChars(env, jname, 0);
	const char *ncname = (*env)->GetStringUTFChars(env, jcname, 0);

	(*env)->ReleaseStringUTFChars(env, jname, nname);
	(*env)->ReleaseStringUTFChars(env, jcname, ncname);

	return test1val++;
}

JNIEXPORT jint JNICALL Java_com_nvidia_devtech_jniperftest_JNIPerfTest_ntest2(JNIEnv *env, jobject obj, jstring jname, jboolean f_type, jstring jcname, jboolean reg)
{
	const char *nname = (*env)->GetStringUTFChars(env, jname, 0);
	const char *ncname = (*env)->GetStringUTFChars(env, jcname, 0);

	(*env)->ReleaseStringUTFChars(env, jname, nname);
	(*env)->ReleaseStringUTFChars(env, jcname, ncname);

	return test2val++;
}

JNIEXPORT jint JNICALL Java_com_nvidia_devtech_jniperftest_JNIPerfTest_ntest3(JNIEnv *env, jobject obj, jstring jname, jboolean f_type, jstring jcname, jboolean reg)
{
	const char *nname = (*env)->GetStringUTFChars(env, jname, 0);
	const char *ncname = (*env)->GetStringUTFChars(env, jcname, 0);

	if(f_type == JNI_TRUE) {
		if(reg == JNI_TRUE) {
			if(isActiveProbe(nname) == 1)
				if(isRegCaller(ncname, nname) == 1)
					activeLog(nname);
		}
		else {
			if(isActiveProbe(nname) == 1)
				if(isUnRegCaller(nname) == 1)
					activeLog(nname);
		}
	}
	else {
		if(isActiveProbe(nname) == 1)
			activeLog(nname);
	}

	(*env)->ReleaseStringUTFChars(env, jname, nname);
	(*env)->ReleaseStringUTFChars(env, jcname, ncname);

	return test3val++;
}

JNIEXPORT jint JNICALL Java_com_nvidia_devtech_jniperftest_JNIPerfTest_ntest4(JNIEnv *env, jobject obj, jstring jname, jboolean f_type, jstring jcname, jboolean reg)
{
	const char *nname = (*env)->GetStringUTFChars(env, jname, 0);
	const char *ncname = (*env)->GetStringUTFChars(env, jcname, 0);

	if(f_type == JNI_TRUE) {
		if(reg == JNI_TRUE) {
			if(isActiveProbe(nname) == 1)
				if(isRegCaller(ncname, nname) == 1)
					activeLog(nname);
		}
		else {
			if(isActiveProbe(nname) == 1)
				if(isUnRegCaller(nname) == 1)
					activeLog(nname);
		}
	}
	else {
		if(isActiveProbe(nname) == 1)
			activeLog(nname);
	}

	(*env)->ReleaseStringUTFChars(env, jname, nname);
	(*env)->ReleaseStringUTFChars(env, jcname, ncname);

	return test4val++;
}

JNIEXPORT jint JNICALL Java_com_nvidia_devtech_jniperftest_JNIPerfTest_ntest0(JNIEnv *env, jobject obj)
{
	return test0val++;
}